﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.DAL
{
    public class ContactUsDB
    {
        public static ContactUs GetItem(Guid contactUsID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@ContactUsID", ((contactUsID != Guid.Empty && contactUsID != null) ? contactUsID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.RetrieveObject<ContactUs>("spGetContactUs", parameters);
        }

        public static List<ContactUs> GetList(Guid contactUsID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@ContactUsID", ((contactUsID != Guid.Empty && contactUsID != null) ? contactUsID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.RetrieveList<ContactUs>("spGetContactUs", parameters);
        }

        public static DataTable GetDataTable(Guid contactUsID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@ContactUsID", ((contactUsID != Guid.Empty && contactUsID != null) ? contactUsID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.ExecuteDataTable("spGetContactUs", parameters);
        }

        public static DataSet GetDataSet(Guid contactUsID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@ContactUsID", ((contactUsID != Guid.Empty && contactUsID != null) ? contactUsID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.ExecuteDataSet("spGetContactUs", parameters);
        }

        public static void Save(ContactUs myNewsLetter)
        {
            myNewsLetter.Mode = ((myNewsLetter.UniqueID != Guid.Empty && myNewsLetter.UniqueID != null) ? GlobalConfigurations.Mode.Update : GlobalConfigurations.Mode.Insert);
            myNewsLetter.UniqueID = ((myNewsLetter.UniqueID != Guid.Empty && myNewsLetter.UniqueID != null) ? myNewsLetter.UniqueID : Guid.NewGuid());
            if (myNewsLetter.Mode == GlobalConfigurations.Mode.Insert)
            {
                myNewsLetter.IsActive = true;
                //myOrders.IsDeleted = false;
            }

            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@ContactUsID", myNewsLetter.UniqueID));
            parameters.Add(new SqlParameter("@Name", (string.IsNullOrEmpty(myNewsLetter.Name) ? (object)DBNull.Value : myNewsLetter.Name)));
            parameters.Add(new SqlParameter("@CAddress", (string.IsNullOrEmpty(myNewsLetter.CAddress) ? (object)DBNull.Value : myNewsLetter.CAddress)));
            parameters.Add(new SqlParameter("@CompanyName", (string.IsNullOrEmpty(myNewsLetter.CompanyName) ? (object)DBNull.Value : myNewsLetter.CompanyName)));
            parameters.Add(new SqlParameter("@City", (string.IsNullOrEmpty(myNewsLetter.City) ? (object)DBNull.Value : myNewsLetter.City)));
            parameters.Add(new SqlParameter("@PhoneNo", (string.IsNullOrEmpty(myNewsLetter.PhoneNo) ? (object)DBNull.Value : myNewsLetter.PhoneNo)));
            parameters.Add(new SqlParameter("@Country", (string.IsNullOrEmpty(myNewsLetter.Country) ? (object)DBNull.Value : myNewsLetter.Country)));
            parameters.Add(new SqlParameter("@Email", (string.IsNullOrEmpty(myNewsLetter.Email) ? (object)DBNull.Value : myNewsLetter.Email)));
            parameters.Add(new SqlParameter("@CSubject", (string.IsNullOrEmpty(myNewsLetter.CSubject) ? (object)DBNull.Value : myNewsLetter.CSubject)));
            parameters.Add(new SqlParameter("@CMessage", (string.IsNullOrEmpty(myNewsLetter.CMessage) ? (object)DBNull.Value : myNewsLetter.CMessage)));
            parameters.Add(new SqlParameter("@IsActive", myNewsLetter.IsActive));

            SQLHelper.ExecuteQuery("spAddOrUpdateContactUs", parameters);
        }
    }
}
